package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.FacadeSearchDataCommon;
import com.bxm.doris.facade.model.datapark.BehaviorData;
import com.bxm.doris.facade.model.datapark.SearchDataCommon;
import com.bxm.doris.facade.model.datapark.TicketData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface TicketFacadeService {

    /**
     * 查找一段时间内存在曝光数据的券id
     * @param beginDate 开始时间
     * @param endDate 结束时间
     * @return 券id
     */
    @GetMapping("/ticket/findHasExposeDataTicketId")
    List<Long> findHasExposeDataTicketId(@RequestParam("beginDate") String beginDate, @RequestParam("endDate") String endDate);



    /**
     * 获取券数据
     * @param search
     * @return
     */
    @RequestMapping("/data/ticket")
    List<TicketData> getAdTicketData(@RequestBody FacadeSearchDataCommon search);



    /**
     * 查找广告主后台-广告数据
     */
    @PostMapping("/ticket/findTicketDataForAdvertiser")
    List<TicketData> findTicketDataForAdvertiser(@RequestBody SearchDataCommon searchDataCommon);

    /**
     * 查找广告行为类型有效点击
     */
    @PostMapping("/ticket/getTicketBehaviorValidClick")
    List<BehaviorData> getTicketBehaviorValidClick(@RequestBody SearchDataCommon searchDataCommon);
}
