package com.bxm.doris.facade.enums;


import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2023-8-09 13:49:00
 */
public enum ISPEnum {
    //移动
    ISP_MOBILE("100025", "中国移动"),
    //电信
    ISP_TELECOM("100017", "中国电信"),
    //联通
    ISP_CHINA("100026", "中国联通"),
    //其他（注意 Doris里面不是 中国移动，联通 中国电信的都是其他，这个sql要特殊处理）
    ISP_OTHER("000000", "000000");


    private String name;

    private String desc;


    ISPEnum(String name, String desc) {
        this.desc = desc;
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static ISPEnum findDescByName(String name) {
        for (ISPEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(name, r.name)) {
                return r;
            }
        }
        return null;
    }

}
