package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.CreativeQueryRequest;
import com.bxm.doris.facade.model.CreativeReviewResponse;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 创意维度facade
 * @author jingyu.li
 * @date 2023-12-22
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface CreativeReviewFacadeService {

    /**
     * 创意分页
     * @param dto
     * @return
     */
    @PostMapping("/getCreativeReviewPage")
    ResponseEntity<PageInfo<CreativeReviewResponse>> getPage(@RequestBody CreativeQueryRequest dto);

    @RequestMapping("/getPv")
    ResponseEntity<List<CreativeReviewResponse>> getPv(@RequestParam("thedate") String thedate);
}
