package com.bxm.doris.facade.model.monitor;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 监控报警基础数据表
 *
 * @author pf.w
 * @since 2023-12-13
 */
@Data
public class FacadeDmAdAlarmDataMinutely implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * yyyyMMddHHmm
     */
    private String thedate;

    /**
     * RTB平台
     */
    private Integer rtbId;

    /**
     * 开发者
     */
    private String appkey;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 礼券ID
     */
    private Integer ticketId;

    /**
     * 中间页pv
     */
    private int midPagePv;

    /**
     * 活动曝光pv
     */
    private int indexPv;

    /**
     * 活动参与pv
     */
    private int joinPv;

    /**
     * 发券请求
     */
    private int sendPv;

    /**
     * 券曝光
     */
    private int openPv;

    /**
     * 券点击
     */
    private int clickPv;

    /**
     * 有效点击去重
     */
    private int validClickPv;

    /**
     * 有效点击不去重
     */
    private int validClickRepeatPv;

    /**
     * 券消耗：单位元
     */
    private BigDecimal consume;

    /**
     * 回传成功数
     */
    private int sendValidPv;

    /**
     * 回传总数
     */
    private int totalValidPv;

    /**
     * 落地页pv不去重
     */
    private int exposurePv;

    /**
     * 中间页uid去重
     */
    private int  midPageUv;

    private int rtbClickUv;


    public static final String THEDATE = "thedate";

    public static final String RTB_ID = "rtb_id";

    public static final String APPKEY = "appkey";

    public static final String POSITION_ID = "position_id";

    public static final String TICKET_ID = "ticket_id";

    public static final String MID_PAGE_PV = "mid_page_pv";

    public static final String INDEX_PV = "index_pv";

    public static final String JOIN_PV = "join_pv";

    public static final String SEND_PV = "send_pv";

    public static final String OPEN_PV = "open_pv";

    public static final String CLICK_PV = "click_pv";

    public static final String VALID_CLICK_PV = "valid_click_pv";

    public static final String VALID_CLICK_REPEAT_PV = "valid_click_repeat_pv";

    public static final String CONSUME = "consume";

    public static final String SEND_VALID_PV = "send_valid_pv";

    public static final String TOTAL_VALID_PV = "total_valid_pv";

    public static final String EXPOSURE_PV = "exposure_pv";

    public static final String MID_PAGE_UV = "mid_page_uv";

    public static final String RTB_CLICK_UV = "rtb_click_uv";
}
