package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.FacadeAdAssetsData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface TicketAssetsFacadeService {

    /**
     * 根据ticketId 查出所有素材 统计
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/assets/getDataByTicket", method = RequestMethod.POST, consumes = "application/json")
    List<FacadeAdAssetsData> getDataByTicket(@RequestParam("startTime") String startTime,
                                             @RequestParam("endTime") String endTime,
                                             @RequestParam("ticketId") Long ticketId);

}
