package com.bxm.sync.facade.service;

import com.bxm.sync.facade.dto.UserAssociateDataDTO;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import com.bxm.sync.facade.dto.UserUseEggNumDTO;

import java.util.List;

/**
 * 6享数据统计内部接口
 *
 * @author lowi
 * @date 2021/9/16 14:10
 */

public interface SixEnjoyDataStatisticsService {

    /**
     * 用户兑换券统计信息
     *
     * @param userId 用户id
     * @return 用户券信息
     */
    UserCouponsStatisticsDTO getCouponsStatistics(Long userId);

    /**
     * 用户获取联营人统计信息
     *
     * @param userId    用户id
     * @param isCompany 是否是代理人
     * @return 用户联营人信息
     */
    UserAssociateDataDTO getUserAssociateData(Long userId, Boolean isCompany);


    /**
     * 获取用户使用了最多蛋的列表
     *
     * @return 用户使用最多蛋列表
     */
    List<UserUseEggNumDTO> getUserUseEggNumMaxList();
}
