package com.bxm.fossicker.activity.facade.model;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * <p>
 * 用户任务详细信息，每日定时重置任务状态和信息
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityUserTaskFacadeDTO extends BaseBean {

    /**
     * 主键
     */
    private Long id;
    /**
     * 任务编码
     */
    private String taskCode;
    /**
     * 任务状态（0：未完成，1：已完成未领取，2：已领取）
     */
    private Integer status;
    /**
     * 任务剩余可完成次数
     */
    private Integer residueTime;
    /**
     * 是否显示（一次性任务完成后不再显示）1：显示，0：隐藏
     */
    private Integer display;
    /**
     * 最后显示时间点
     */
    private Date lastDisplayTime;
    /**
     * 任务所属用户
     */
    private Long userId;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date modifyTime;

}
