package com.bxm.fossicker.activity.facade.model;

import com.bxm.fossicker.vo.BaseBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "抽奖简略信息")
@Data
public class LotteryDTO extends BaseBean {

    @ApiModelProperty("抽奖活动ID")
    private Long lotteryId;

    @ApiModelProperty("抽奖期数ID")
    private Long phaseId;

    @ApiModelProperty("抽奖期编号")
    private String phaseNum;

    @ApiModelProperty("奖品标题")
    private String title;

    @ApiModelProperty("列表图地址")
    private String listImgUrl;

    @ApiModelProperty("当前请求用户的参与次数")
    private Integer times;

    @ApiModelProperty("活动开启需要的人数")
    private Integer conditionNum;

    @ApiModelProperty("当前参与人数")
    private Integer participantNum;

    @ApiModelProperty("抽奖期数当前状态，0：未开始、1：进行中、2：已完成、3：取消")
    private Integer status;

    @ApiModelProperty("开奖时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date winTime;
}
