package com.bxm.fossicker.activity.model.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;

/**
 * @auther Gonzo
 * @date 2019-09-06 14:25
 */
public class ActivityRedisKey {

    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("activity");

    /**
     * 宝箱活动key
     */
    public static KeyGenerator TREASURE_BOX_CACHE = BASE_KEY.copy().setGroup("cache").setKey("treasureBox");

    /**
     * 每日看视频3次活动
     */
    public static KeyGenerator WATCH_VIDEO = BASE_KEY.copy().setGroup("cache").setKey("watchVideo");

    /**
     * 翻倍活动限制key
     */
    public static KeyGenerator DOUBLE_GOLD_LIMIT = BASE_KEY.copy().setGroup("double").setKey("gold");

    /**
     * 邀请好友map key
     */
    public static KeyGenerator INVITE_USER_MAP = BASE_KEY.copy().setGroup("invite").setKey("map");

    /**
     * 不展示填写邀请码的用户id集合
     */
    public static KeyGenerator NOT_SHOW_WRITE_INVITE_CODE = BASE_KEY.copy().setGroup("notshow").setKey("inviteCode");

    /**
     * 记录已被邀请登录奖励的用户map key
     */
    public static KeyGenerator HAVA_REWARD_LOGIN_INVITE = BASE_KEY.copy().setGroup("reward").setKey("login");

    /**
     * 日常任务状态
     */
    public static KeyGenerator DAILY_TASK_STATUS = BASE_KEY.copy().setGroup("task").setKey("daily");

    /**
     * 每日福利
     */
    public static KeyGenerator DAILY_WELFARE = BASE_KEY.copy().setGroup("task").setKey("welfare");

    /**
     * 登录奖励
     */
    public static KeyGenerator LOGIN_REWARD = BASE_KEY.copy().setGroup("cache").setKey("loginReward");

    /**
     * 登录领取奖励并发锁
     */
    public static KeyGenerator LOGIN_REWARD_LOCK = BASE_KEY.copy().setGroup("cache").setKey("loginRewardLock");


    public static KeyGenerator buildDailyTaskStatusKey(Long userId) {
        return ActivityRedisKey.DAILY_TASK_STATUS.copy().appendKey(DateUtils.getCurrentDate()).appendKey(userId);
    }
}
