package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName DayGoldRedPacketDto
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/6/21 16:26
 * @Version 1.0.0
 **/
@ApiModel("天天领现金红包Dto")
@Data
@Builder
public class DayGoldRedPacketDto {
    @ApiModelProperty("表示第几天：共7天，返回结果为1-7的数字")
    private Integer day;

    @ApiModelProperty("红包状态,0:已过期，1：已领取,2:待领取,3:暂不可领")
    private Integer status;

    @ApiModelProperty("金币数，已转化为万为单位，例如：0.12万")
    private String gold;

    @ApiModelProperty(value = "金币数", hidden = true)
    private BigDecimal goldNum;
}
