package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 好友邀请信息
 * @author Dong_hy
 */
@ApiModel(value = "好友邀请信息")
@Data
@Builder
public class FriendsInviteInfoDTO {

    @Tolerate
    public FriendsInviteInfoDTO() {
    }

    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickName;

    /**
     * 头像
     */
    @ApiModelProperty(value = "头像")
    private String headImg;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phoneNum;

    /**
     * 邀请成功时间
     */
    @ApiModelProperty(value = "邀请成功时间")
    private String inviteSuccessTime;

    /**
     * 收益
     */
    @ApiModelProperty(value = "收益")
    private Double earnings;

    /**
     * 金币收益
     */
    @ApiModelProperty(value = "金币收益")
    private Integer goldEarnings;

    /**
     * 邀请成功标志 true-成功 false-失败
     */
    @ApiModelProperty(value = "邀请成功标志 1.4.2改为下载登录成功")
    private Boolean inviteSuccessFlag;

    /**
     * 登录成功标志 true-成功 false-失败
     */
    @ApiModelProperty(value = "登录成功标志 1.4.2改为淘宝、微信绑定成功")
    private Boolean loginSuccessFlag;

    /**
     * vip领取成功 true-成功 false-失败
     */
    @ApiModelProperty(value = "vip领取成功标志")
    private Boolean vipSuccessFlag;

    /**
     * 月卡张数,vip领取标志位为true才会有值
     */
    @ApiModelProperty(value = "月卡张数,vip领取标志位为true才会有值")
    private Integer vipCardNum;

    /**
     * 邀请类型
     */
    @ApiModelProperty(value = "邀请类型，比如0元购 需要在左上角展示 VIP_ZERO_COMMODITY:0元购")
    private String inviteType;

    /**
     * 文案提示
     */
    @ApiModelProperty(value = "文案提示，比如<提醒好友开通黑钻卡，得5元 现金奖励>")
    private String desc;
}
