package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("邀请结果DTO")
@Data
public class InviteResultDTO {

    /**
     * 是否成功
     */
    @ApiModelProperty(value = "邀请是否成功 true-成功, false-失败")
    private Boolean success;

    /**
     * 结果信息
     */
    @ApiModelProperty(value = "请求结果信息")
    private String errorMessage;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "用户昵称")
    private String nickName;

    @ApiModelProperty(value = "用户头像")
    private String headImg;

    /**
     * 请求失败的构造函数
     * @param errorMessage 错误信息
     */
    public InviteResultDTO (String errorMessage) {
        this.success = false;
        this.errorMessage = errorMessage;
    }

    /**
     * 请求成功的构造函数
     * @param userId 用户id
     * @param nickName 昵称
     * @param headImg 头像
     */
    public InviteResultDTO(Long userId, String nickName, String headImg) {
        this.success = true;
        this.userId = userId;
        this.nickName = nickName;
        this.headImg = headImg;
    }
}
