package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName SignDaysDto
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/6/21 17:46
 * @Version 1.0.0
 **/
@ApiModel(description = "签到日信息Dto")
@Data
public class SignDaysDto {

    @ApiModelProperty("标志第几天，值为1-15的数字")
    private Integer day;

    @ApiModelProperty("签到状态，0未签到，1已签到")
    private Integer status;

    @ApiModelProperty("奖励金币")
    private Integer golds;

    @ApiModelProperty("是否有额外金币奖励")
    private Boolean hasExtraGolds;

    @ApiModelProperty("额外金币")
    private Integer extraGolds;

    @ApiModelProperty("是否是今天未签到，即在这天显示签到标识，需要显示则为true")
    private Boolean todayShowSign = false;

}
