package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @ClassName NewUserTask
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/6/20 13:44
 * @Version 1.0.0
 **/
@ApiModel(description = "任务列表查询结果Dto")
@Data
public class TaskDto {

    @ApiModelProperty("任务id")
    private Long taskId;

    @ApiModelProperty("用户与任务绑定的id")
    private Long bindId;

    @ApiModelProperty("用户的任务状态 0：未完成，1：已完成未领取，2：已领取")
    private String status;

    @ApiModelProperty("任务标题")
    private String title;

    @ApiModelProperty("任务描述文案")
    private String description;

    @ApiModelProperty("任务图标图片地址")
    private String icon;

    @ApiModelProperty("任务处理协议地址")
    private String url;

    @ApiModelProperty("任务奖励")
    private String reward;

    @ApiModelProperty("任务奖励类型（1：现金，2：金币）")
    private String rewardType;

    @ApiModelProperty("任务详细说明(弹框内容)")
    private List<String> promptImgs;

    @ApiModelProperty("按钮文案")
    private String buttonText;

    @ApiModelProperty(value = "任务类型", hidden = true)
    private String type;

}
