package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;
import java.util.Map;

/**
 * @ClassName TaskListDto
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/15 15:11
 * @Version 1.0.0
 **/
@ApiModel(description = "任务列表查询结果List")
@Data
@Builder
public class TaskListDto {

    @Tolerate
    public TaskListDto() {
    }

    @ApiModelProperty("任务类型0新手任务，1日常任务")
    private String type;

    @ApiModelProperty("完成任务数量")
    private Integer completeNum;

    @ApiModelProperty("任务总数量")
    private Integer totalNum;

    @ApiModelProperty("是否看过激励视频 1：已看过 0:未看过")
    private Byte dailyWelfareFlag;

    @ApiModelProperty("红包状态  0：不能领取 1：待领取 2:已领取")
    private Byte status;

    @ApiModelProperty("每日福利奖励总金额，如 1200")
    private Integer dailyWelfareAmount;

    @ApiModelProperty("任务列表")
    private List<TaskDto> taskList;
}
