package com.bxm.fossicker.activity.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@ApiModel(value = "好友总体信息DTO")
@Data
@Builder
public class TotalFriendsInfoDTO {

    @Tolerate
    public TotalFriendsInfoDTO() {
    }

    /**
     * 好友总数
     */
    @ApiModelProperty("好友总数")
    private Integer friendNum;

    /**
     * 收益
     */
    @ApiModelProperty("收益")
    private Double earnings;

    /**
     * 总收益
     */
    @ApiModelProperty("总收益")
    private Double totalEarnings;


}
