package com.bxm.fossicker.activity.model.dto.lottery;

import com.bxm.fossicker.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "抽奖机会实体")
@Data
@Builder
public class LotteryChanceDTO extends BaseBean {

    @Tolerate
    public LotteryChanceDTO() {
    }

    @ApiModelProperty("免费抽奖的次数上限")
    private Integer maxChances;

    @ApiModelProperty("剩余免费抽奖的次数，如果剩余次数为0，则显示通知和倒计时")
    private Integer residueChances;

    @ApiModelProperty("抽奖次数为0时，下次免费获取抽奖次数的秒数")
    private Long nextChanceSeconds;
}
