package com.bxm.fossicker.activity.model.dto.lottery;

import com.bxm.fossicker.vo.BaseBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动参与人信息")
@Data
@Builder
public class LotteryParticipantDTO extends BaseBean {
    @Tolerate
    public LotteryParticipantDTO() {
    }

    @ApiModelProperty("参与人ID")
    private Long userId;

    @ApiModelProperty("参与人昵称")
    private String nickName;

    @ApiModelProperty("参与人头像")
    private String headImg;

    @ApiModelProperty("参与时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date joinTime;

    @ApiModelProperty("参与奖券号码")
    private String code;

    @ApiModelProperty(value = "参与奖券号码顺序", hidden = true)
    private int codeIndex;
}
