package com.bxm.fossicker.activity.model.dto.lottery;

import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动期数详情")
@Data
@Builder
public class LotteryPhaseDetailDTO extends LotteryDTO {

    @Tolerate
    public LotteryPhaseDetailDTO() {
    }

    @ApiModelProperty("抽奖活动详情图片地址")
    private String detailImgUrl;

    @ApiModelProperty("本期活动开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;

    @ApiModelProperty("奖品价值")
    private BigDecimal cost;

    @ApiModelProperty("参与用户信息列表，第一页，为空时不显示参与记录")
    private PageWarper<LotteryParticipantDTO> firstPageParticipant;

    @ApiModelProperty("最新一期活动ID，如果为空则表示该活动已无最新一期")
    private Long lastPhaseId;

    @ApiModelProperty("中奖人ID")
    private String winnerId;

    @ApiModelProperty("中奖人昵称")
    private String winnerName;

    @ApiModelProperty("中奖人头像地址")
    private String winnerHead;

    @ApiModelProperty("中奖人中奖编码")
    private String winnerCode;

    @ApiModelProperty("我的夺宝劵号码")
    private List<String> myCodes;
}
