package com.bxm.fossicker.activity.model.dto.lottery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@ApiModel(description = "参与抽奖结果返回")
@Data
@Builder
public class LotteryPhaseJoinDTO {

    @Tolerate
    public LotteryPhaseJoinDTO() {
    }

    @ApiModelProperty("参与状态，1：参与成功，2：次数不足,3:参与次数达到上限,4:活动已完成")
    private Integer status;

    @ApiModelProperty("参与结果的提示文案")
    private String tooltipMsg;

    @ApiModelProperty("奖券号码，参与成功后才有值")
    private String lotteryCode;

    @ApiModelProperty("次数不足时，下次获取抽奖机会的秒数")
    private Long nextChanceSeconds;

    @ApiModelProperty("活动结束状态时，返回最后一期活动的ID，如果为null，表示没有下一期")
    private Long lastPhaseId;
}
