package com.bxm.fossicker.activity.model.dto.lottery;

import com.bxm.fossicker.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "抽奖中奖人员计算公式")
@Data
@Builder
public class LotteryWinnerCalDTO extends BaseBean {

    @Tolerate
    public LotteryWinnerCalDTO() {
    }

    @ApiModelProperty("最终奖券号码")
    private String winnerCode;

    @ApiModelProperty("参与人数")
    private Integer participantNum;

    @ApiModelProperty("最后N条参与人时间汇总结果")
    private Long lastCount;

    @ApiModelProperty("最后N条参与夺宝的参与时间与转换格式")
    private List<LotteryJoinTime> joinTimeList;
}
