package com.bxm.fossicker.activity.model.entry;

import lombok.Data;

/**
 * 广告查询结果
 **/
@Data
public class AdvertEntry {

    /**
     * 广告素材id
     */
    private Long materialId;

    /**
     * 素材标题
     */
    private String title;

    /**
     * 素材副标题
     */
    private String subTitle;

    /**
     * 素材类型,1-文字，2-图片，3-任务素材
     */
    private Integer type;

    /**
     * 素材文字内容
     */
    private String content;

    /**
     * 显示文案
     */
    private String description;

    /**
     * 图片高度
     */
    private String imgHeight;

    /**
     * 图片宽度
     */
    private String imgWidth;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 跳转协议地址
     */
    private String url;

    /**
     * 图标图片地址
     */
    private String iconUrl;

    /**
     * 审核展示标志,0-不限,1-非审核状态下展示,2-审核状态下展示
     */
    private Integer approvalFlag;

    /**
     * 平台,0-不限,1-ios,2-android
     */
    private Integer platform;

    /**
     * 前置条件 0-无 1：授权淘宝 2：版本更新 3：vip --已失效，用preconditions字段标识多个前置条件
     * 如果是老版本，只会返回版本更新条件
     */
    private Integer precondition;

    /**
     * 前置条件 1：授权淘宝 2：版本更新 3：vip 多个条件的组合 , 分割
     */
    private String preconditions;

    /**
     * 是否热词
     */
    private Boolean hot;

    /**
     * 淘宝联盟推广位ID
     */
    private String adzoneId;

}
