package com.bxm.fossicker.activity.model.enums;

/**
 * 广告位置枚举定义
 *
 * @author Gonzo
 * @date 2019-08-21 10:10
 */
@SuppressWarnings({"AlibabaEnumConstantsMustHaveComment", "unused"})
public enum AdvertPositionEnum {

    /**
     * 所有添加的广告位必须在这里定义
     */
    HOME_PAGE_BANNER(1, "首页BANNER区域"),
    HOME_PAGE_ICONS(2, "首页ICON快捷入口"),
    USER_PAGE_BANNER(3, "我的BANNER区域"),
    USER_PAGE_ICONS(4, "我的ICON区域"),
    GOLD_DETAIL_BOTTON_BANNER(5, "金币明细底部banner"),
    GOLD_WITHDRAW_DIALOG(6, "金币提现弹窗"),
    CASH_WITHDRAW_DIALOG(7, "佣金提现弹窗"),
    TJG_BANNER(8, "淘金谷橱窗"),
    SWLH_BANNER(9, "淘金谷橱窗"),
    DAILY_TASK_LIST(10, "淘金谷橱窗"),
    USER_PAGE_TOP_BUTTON(11, "我的顶部按钮"),
    ZERO_PAGE_BANNER(12, "0元购顶部banner"),
    SWLH_APP_LIST(13, "试玩零花app列表信息"),
    PRESELL_PAGE_BANNER(14, "双十一预售banner"),
    HOME_PAGE_TRUNK_BANNER(15, "首页胶囊banner"),
    HOME_PAGE_WINDOWS(16, "首页橱窗"),
    USER_PAGE_CENTER_BANNER(17, "我的页面BANNER区域"),
    ACTIVITY_PAGE_TEMPLATE_BANNER(18, "活动模板banner"),
    SEARCH_PAGE_HOT_SEARCH_WORDS(19, "搜索页热搜词"),
    HOME_PAGE_HOT_SEARCH_WORDS(20, "首页热搜词"),
    ELE_ADVERTISEMENT(21, "饿了么广告位"),
    VIP_CENTER(23, "会员权益广告位"),
    TASK_CENTER_BANNER(24, "福利社Banner"),
    VIP_CENTER_MORE(25, "会员中心更多权益"),
    ;

    private int position;

    private String des;


    AdvertPositionEnum(int position, String des) {
        this.position = position;
        this.des = des;
    }

    public static AdvertPositionEnum getByPosition(int position) {
        AdvertPositionEnum[] advertisementPositions = AdvertPositionEnum.values();

        for (AdvertPositionEnum advertisementPosition : advertisementPositions) {
            if (position == advertisementPosition.getPosition()) {
                return advertisementPosition;
            }
        }

        return null;
    }


    public int getPosition() {
        return position;
    }

    public String getDes() {
        return des;
    }
}
