package com.bxm.fossicker.activity.model.enums;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 新手任务枚举
 *
 * @author xin.zhao
 */
public enum NewUserTaskEnum {
    INPUT_INVITE("输入邀请码"),
    VIEW_GOODS("逛商品赚金币"),
    VIEW_VIDEO("观看视频教程"),
    SEARCH_TITLE("淘宝标题搜券"),
    AUTH_TAOBAO("授权淘宝"),
    FIRST_SHOP("完成首次购物"),
    BIND_WECHAT("微信授权"),
    FINISH_PERSONAL_INFO("完善我的标签");

    private String taskName;

    private static Set<String> newUserTaskNames;

    static {
        newUserTaskNames = Arrays.stream(NewUserTaskEnum.values())
                .map(NewUserTaskEnum::name)
                .collect(Collectors.toSet());
    }

    NewUserTaskEnum(String taskName) {
        this.taskName = taskName;
    }

    /**
     * 获取新手任务列表
     * @return 新手任务Set集合
     */
    public static Set<String> getNewUserTaskNames() {
        return newUserTaskNames;
    }

}
