package com.bxm.fossicker.activity.model.param;

import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @authoer Gonzo
 * @date 2019-08-21 10:22
 */
@EqualsAndHashCode(callSuper = true)
@ToString
@Data
@ApiModel(description = "广告查询入参")
public class AdvertParam extends BasicParam {

    /**
     * @see AdvertPositionEnum
     */
    @ApiModelProperty(value = "投放位置类型,1：首页BANNER区域 2：首页ICON快捷入口 3：我的BANNER区域 4：我的ICON区域 5：金币明细底部banner 6：金币提现弹窗 " +
            "7：佣金提现弹窗 8：.淘金谷橱窗 9：试玩零花banner 10：日常任务 11：我的顶部按钮 12：0元购顶部banner 13：试玩零花app列表信息 14：双十一预售banner " +
            "15：首页胶囊banner 16 ：首页橱窗 17：我的页面BANNER区域，18：活动模板banner，19：搜索页热搜词，20：首页热搜词，21：饿了么广告位 23：会员权益广告位," +
            "24:福利社Banner, 25: 会员中心更多权益",
            required = true)
    private Integer position;

    @ApiModelProperty(value = "用户id ", required = true)
    private Long userId;

    @ApiModelProperty(value = "是否开启了通知 true:是 1.1.0版本新增")
    private Boolean openNotice;
}
