package com.bxm.fossicker.activity.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName BindInviteParam
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/6/20 14:20
 * @Version 1.0.0
 **/
@ApiModel(description = "绑定邀请关系入参")
@Data
public class BindInviteParam {

    /**
     * 用户id
     */
    @ApiModelProperty(value = "当前用户id", required = true)
    private Long userId;

    /**
     * 输入值，可以为邀请码或者手机号
     */
    @ApiModelProperty(value = "输入值，可以为邀请码或者手机号", required = true)
    private String inputCode;

    /**
     * 邀请用户id
     */
    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

}
