package com.bxm.fossicker.activity.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author: pf.w
 * @Date: 2019/10/12 18:18
 */
@ApiModel(description = "回调参数")
@Data
public class TaskCallBackParam extends ExternalBasicParam{

    @ApiModelProperty("用户id")
    private Long uid;

    @ApiModelProperty("广告id")
    private Long adid;

    @ApiModelProperty("广告名称")
    private String adname;

    @ApiModelProperty("渠道编号")
    private String channel;

    @ApiModelProperty("订单编号")
    private String ordernum;

    @ApiModelProperty("奖励级别")
    private int dlevel;

    @ApiModelProperty("用户体验游戏包名")
    private String pagename;

    @ApiModelProperty("手机设备号imei或idfa")
    private String deviceid;

    @ApiModelProperty("手机sim卡id")
    private String simid;

    @ApiModelProperty("用户体验游戏注册的账号id")
    private Long merid;

    @ApiModelProperty("奖励说明desc")
    private String event;

    @ApiModelProperty("给渠道的结算的金额 单位：元 （最多保留2位小数)")
    private BigDecimal price;

    @ApiModelProperty("奖励给用户的金额 单位：元 （最多保留2位小数）")
    private BigDecimal money;

    @ApiModelProperty("时间戳")
    private Long itime;
}
