package com.bxm.fossicker.activity.model.param.lottery;

import com.bxm.fossicker.activity.model.vo.lottery.LotteryVirtaulUserBean;
import com.bxm.fossicker.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "抽奖参数")
@Data
@Builder
public class LotteryDrawParam extends BasicParam {
    @Tolerate
    public LotteryDrawParam() {

    }

    @ApiModelProperty("当前用户ID")
    private Long userId;

    @ApiModelProperty("参与活动期数ID")
    private Long phaseId;

    @ApiModelProperty(hidden = true, name = "是否虚拟用户")
    private Boolean virtual = false;

    @ApiModelProperty(hidden = true, name = "虚拟用户信息")
    private LotteryVirtaulUserBean virtaulUser;

    @ApiModelProperty(hidden = true, name = "是否最后一条虚拟用户，用于特殊条件增加")
    private Boolean lastVirtual = false;
}
