package com.bxm.fossicker.activity.model.vo;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 广告投放位置表
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
public class ActivityAdvertPosition implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 广告名称
     */
    private String advertName;
    /**
     * 是否上架（1：是，0：否）
     */
    private Integer enableStatus;
    /**
     * 投放位置类型,1：首页BANNER区域 2：首页ICON快捷入口 3：我的BANNER区域 4：我的ICON区域
     */
    private Integer positionType;
    /**
     * 是否全国投放（0：false，1：true）
     */
    private Integer globalStatus;
    /**
     * 投放开始时间
     */
    private Date startTime;
    /**
     * 投放截止时间
     */
    private Date endTime;
    /**
     * 展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示
     */
    private String showType;
    /**
     * 倒计时时间（特殊广告类型需要）
     */
    private Integer timeout;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 变更时间
     */
    private Date modifyTime;
    /**
     * 发布人
     */
    private Long creator;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getPositionType() {
        return positionType;
    }

    public void setPositionType(Integer positionType) {
        this.positionType = positionType;
    }

    public Integer getGlobalStatus() {
        return globalStatus;
    }

    public void setGlobalStatus(Integer globalStatus) {
        this.globalStatus = globalStatus;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getShowType() {
        return showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    @Override
    public String toString() {
        return "ActivityAdvertPosition{" +
        "id=" + id +
        ", advertName=" + advertName +
        ", enableStatus=" + enableStatus +
        ", positionType=" + positionType +
        ", globalStatus=" + globalStatus +
        ", startTime=" + startTime +
        ", endTime=" + endTime +
        ", showType=" + showType +
        ", timeout=" + timeout +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        ", creator=" + creator +
        "}";
    }
}
