package com.bxm.fossicker.activity.model.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.checkerframework.checker.signature.qual.BinaryNameInUnnamedPackage;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 天天领金币记录表
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Data
@Builder
public class ActivityDayGold extends BaseBean {

    @Tolerate
    public ActivityDayGold() {
    }

    /**
     * 主键
     */
    private Long id;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 第几天
     */
    private Integer dayNum;
    /**
     * 领取状态，1：已领取，0：未领取
     */
    private Integer status;
    /**
     * 预计领取日期(创建用户时同步创建)
     */
    private Date expectDate;
    /**
     * 奖励类型（1：现金，2：金币）
     */
    private Integer awardType;
    /**
     * 奖励数量
     */
    private BigDecimal awardAmount;
    /**
     * 创建日期
     */
    private Date createTime;
}
