package com.bxm.fossicker.activity.model.vo;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 用户签到日志信息
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Data
@ToString
public class ActivitySignLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 签到的奖励金额
     */
    private BigDecimal reward;
    /**
     * 是否补签（1：是，0：否）
     */
    private Integer isRetroactive;
    /**
     * 签到日期
     */
    private Date createTime;
}
