package com.bxm.fossicker.activity.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 任务信息表
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Data
public class ActivityTask implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 任务编码，详见枚举定义，方便触发任务完成
     */
    private String taskCode;
    /**
     * 任务标题
     */
    private String title;
    /**
     * 任务描述文案
     */
    private String description;
    /**
     * 任务详细说明（弹框显示）
     */
    private String prompt;
    /**
     * 任务类型（0:新手任务、1:日常任务）
     */
    private String type;
    /**
     * 任务显示顺序
     */
    private Integer order;
    /**
     * 任务图标图片地址
     */
    private String icon;
    /**
     * 任务处理协议地址
     */
    private String url;
    /**
     * 任务奖励
     */
    private BigDecimal reward;
    /**
     * 任务奖励类型（现金或金币）
     */
    private String rewardType;
    /**
     * 奖励上限值，-1表示不限制
     */
    private BigDecimal rewardLimit;
    /**
     * 任务最多完成次数（-1表示无限制）
     */
    private Integer maxTime;
    /**
     * 是否启用，1：启用、0：禁用
     */
    private Integer enable;
}
