package com.bxm.fossicker.activity.model.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 任务列表查询vo
 *
 * @author xin.zhao
 * @date 2019/6/26 14:28
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityTaskListVo extends BaseBean {

    /**
     * 任务id
     */
    private Long taskId;
    /**
     * 任务标题
     */
    private String title;
    /**
     * 任务类型
     */
    private String type;
    /**
     * 任务描述文案
     */
    private String description;
    /**
     * 任务图标图片地址
     */
    private String icon;
    /**
     * 任务处理协议地址
     */
    private String url;
    /**
     * 任务奖励
     */
    private BigDecimal reward;
    /**
     * 任务奖励类型（现金或金币）
     */
    private String rewardType;

    /**
     * 任务详细说明（弹框显示）
     */
    private String prompt;

    /**
     * 任务类型
     */
    private String taskCode;

    /**
     * 按钮文案
     */
    private String buttonText;
}
