package com.bxm.fossicker.activity.model.vo;

import com.bxm.fossicker.activity.constants.AdvertPrecondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 广告查询结果
 *
 * @ClassName AdvertVo
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/1 13:58
 * @Version 1.0.0
 **/
@Data
@ApiModel(description = "广告Vo")
public class AdvertVo {

    @ApiModelProperty("广告素材id")
    private Long materialId;

    @ApiModelProperty("素材标题")
    private String title;

    @ApiModelProperty("素材副标题")
    private String subTitle;

    @ApiModelProperty("素材类型,1-文字，2-图片，3-任务素材")
    private Integer type;

    @ApiModelProperty("素材文字内容")
    private String content;

    @ApiModelProperty("显示文案")
    private String description;

    @ApiModelProperty("图片高度")
    private String imgHeight;

    @ApiModelProperty("图片宽度")
    private String imgWidth;

    @ApiModelProperty("图片地址")
    private String imgUrl;

    @ApiModelProperty("跳转协议地址")
    private String url;

    @ApiModelProperty("图标图片地址")
    private String iconUrl;

    @ApiModelProperty("审核展示标志,0-不限,1-非审核状态下展示,2-审核状态下展示")
    private Integer approvalFlag;

    @ApiModelProperty("平台,0-不限,1-ios,2-android  ")
    private Integer platform;

    /**
     * @see AdvertPrecondition
     */
    @ApiModelProperty("前置条件 0-无 1：授权淘宝 2：版本更新 3：vip --已失效，用preconditions字段标识多个前置条件" +
            "如果是老版本，只会返回版本更新条件")
    @Deprecated
    private Integer precondition;

    @ApiModelProperty("前置条件 1：授权淘宝 2：版本更新 3：vip 多个条件的组合")
    private List<Integer> preconditions;

    @ApiModelProperty("是否热词")
    private Boolean hot;

    @ApiModelProperty("淘宝联盟推广位ID")
    private String adzoneId;

    @ApiModelProperty("试玩列表app 显示金额 单位元")
    private String showmoney;

    @ApiModelProperty("查看更过URL  试玩和淘金谷时下发    1.3.0新增")
    private String totalUrl;

    @ApiModelProperty("下载地址 ，当precondition = 2的时候下发")
    private String downloadUrl;

    @ApiModelProperty(value = "淘客联盟官方活动id", hidden = true)
    private String promotionSceneId;
}
