package com.bxm.fossicker.activity.model.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 用户邀请关系记录
 * </p>
 *
 * @author XinZhao
 * @since 2019-07-01
 */
@Data
@Builder
public class UserInviteRelation extends BaseBean {
    @Tolerate
    public UserInviteRelation() {
    }

    /**
     * 主键
     */
    private Long id;
    /**
     * 邀请类型
     */
    private String inviteType;
    /**
     * 邀请人ID
     */
    private Long userId;
    /**
     * 被邀请人手机号码
     */
    private String invitedPhone;
    /**
     * 邀请失效时间
     */
    private Date effectTime;
    /**
     * 邀请状态（1：成功，0：失效）
     */
    private Integer status;
    /**
     * 被邀请人ID
     */
    private Long invitedId;
    /**
     * 被邀请人姓名
     */
    private String invitedName;
    /**
     * 被邀请人头像
     */
    private String invitedHeadImg;
    /**
     * 今日提醒状态（0未提醒，1已提醒）
     */
    private Integer remindStatus;
    /**
     * 创建时间（发起邀请时间）
     */
    private Date createTime;
    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 邀请的版本,0-金币收益版本,1-现金收益版本
     */
    private Integer inviteVersion;

    /**
     * 邀请收益
     */
    private BigDecimal inviteEarning;

    /**
     * 邀请收益
     */
    private Integer goldEarnings;

    /**
     * 邀请成功时间
     */
    private Date inviteSuccessTime;

    /**
     * 每邀请3位用户获取vip的消费状态,0-未被消费,1-已被消费
     */
    private Integer consumeStatus;
}
