package com.bxm.fossicker.activity.model.vo.lottery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(description = "活动信息")
@Data
@Builder
public class LotteryBean implements Serializable {

    @Tolerate
    public LotteryBean() {
    }

    @ApiModelProperty("奖品ID")
    private Long id;

    @ApiModelProperty("奖品显示标题")
    private String title;

    @ApiModelProperty("奖品列表图片")
    private String listImgUrl;

    @ApiModelProperty("详情图片地址")
    private String detailImgUrl;

    @ApiModelProperty("奖品价值")
    private BigDecimal cost;

    @ApiModelProperty("开奖需要的人数")
    private Integer conditionNum;

    @ApiModelProperty("order")
    private Integer order;

    /**
     * 开启时间
     */
    @ApiModelProperty(hidden = true)
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(hidden = true)
    private Long creator;

    /**
     * 变更时间
     */
    @ApiModelProperty(hidden = true)
    private Date modifyTime;

    /**
     * 是否删除
     */
    @ApiModelProperty(hidden = true)
    private Boolean deleteFlag;

    /**
     * 删除时间
     */
    @ApiModelProperty(hidden = true)
    private Date deleteTime;

    /**
     * 删除人
     */
    @ApiModelProperty(hidden = true)
    private Long deleter;

    /**
     * 当前总期数
     */
    @ApiModelProperty(hidden = true)
    private Integer phaseCount;

    /**
     * 活动当前状态，0：下架，1：上架
     */
    @ApiModelProperty(hidden = true)
    private int status;

    private static final long serialVersionUID = 1L;
}