package com.bxm.fossicker.activity.model.vo.lottery;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * t_activity_lottery_phase
 *
 * @author
 */
@Data
@Builder
public class LotteryPhaseBean implements Serializable {

    @Tolerate
    public LotteryPhaseBean() {

    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 抽奖活动ID
     */
    private Long lotteryId;

    /**
     * 活动期数
     */
    private String phaseNum;

    /**
     * 活动状态0：未开始、1：进行中、2：已完成、3：取消
     */
    private Integer status;

    /**
     * 本期活动显示的中奖人ID
     */
    private Long winnerId;

    /**
     * 本期活动显示的中奖人头像
     */
    private String winnerHeadUrl;

    /**
     * 本期活动显示的中奖人昵称
     */
    private String winnerName;

    /**
     * 中奖人奖券号码
     */
    private String winnerCode;

    /**
     * 开奖时间
     */
    private Date winTime;

    /**
     * 活动开启需要的人数
     */
    private Integer conditionNum;

    /**
     * 当前已参与人数
     */
    private Integer participantNum;

    /**
     * 活动开启时间
     */
    private Date createTime;

    /**
     * 活动变更时间
     */
    private Date modifyTime;

    /**
     * 当前活动最新一期ID
     */
    private Long lastPhaseId;

    private static final long serialVersionUID = 1L;
}