package com.bxm.fossicker.activity.lottery.service;

import com.bxm.fossicker.activity.model.dto.lottery.LotteryWinnerCalDTO;

import java.util.Date;

/**
 * 全民抽奖-抽奖接口
 */
public interface LotteryDrawService {

    /**
     * 全民抽奖活动开奖 <br/>
     *
     * @param phaseId 活动期ID
     * @param title   商品名称
     */
    void doDraw(Long phaseId, String title);

    /**
     * 推送公众号消息
     *
     * @param phaseId 活动期数
     * @param title   奖品
     * @param time    开奖时间
     */
    void pushWxMessage(Long phaseId, String title, Date time);

    /**
     * 获取计算过程
     *
     * @param phaseId 活动期数ID
     * @return 计算过程相关结果
     */
    LotteryWinnerCalDTO getCalProcess(Long phaseId);
}
