package com.bxm.fossicker.activity.lottery.service;

import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryCarouselDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryCompleteDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseDetailDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryPhaseBean;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 全民抽奖-每一期活动控制相关服务接口
 */
public interface LotteryPhaseService {

    /**
     * 根据活动基础信息创建一期活动，在前一期的基础上+1 <br/>
     * 创建定时任务，定期增加虚拟用户 <br/>
     * 更新活动中总期数
     *
     * @param lottery 活动信息
     */
    void createPhase(LotteryBean lottery);

    /**
     * 重启活动，当活动重新上架后进行处理
     * 重新开启定时任务
     *
     * @param lottery 活动信息
     */
    void resumePhase(LotteryBean lottery);

    /**
     * 活动结束，关闭活动
     * 清除本期活动缓存，开启下一期活动
     *
     * @param entity 活动信息
     */
    void closePhase(LotteryPhaseBean entity);

    /**
     * 中奖信息轮播
     *
     * @return 轮播列表
     */
    List<LotteryCarouselDTO> getCarousel();

    /**
     * 变更活动对应的最新一期信息
     * 变更活动需要的参与人数，如果人数小于或等于已参与人数则不变更
     *
     * @param lottery 活动信息
     * @return 变更结果
     */
    Message modify(LotteryBean lottery);

    /**
     * 停止活动的最新一期，如果活动参与人包含真实用户则不做处理
     * 删除定时任务
     *
     * @param lottery 活动信息
     * @return 操作结果，不做处理也返回成功
     */
    Message cancel(LotteryBean lottery);

    /**
     * 开启新一期活动时，设置历史数据中的当前期数，用于定位到最新的一期活动
     *
     * @param lotteryId 活动ID
     * @param phaseId   最新一期活动，更新时不包含自身
     */
    void changeLastPhase(Long lotteryId, Long phaseId);

    /**
     * 加载活动期的缓存数据(只有活动基础数据)
     *
     * @param phaseId 活动ID
     * @return 活动详情
     */
    LotteryPhaseDetailDTO loadCache(Long phaseId);

    /**
     * 清除活动期缓存
     */
    void cleanCache(Long phaseId);

    /**
     * 获取奖品列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    PageWarper<LotteryDTO> getPhaseList(LotteryQueryParam param);

    /**
     * 分页获取开奖记录列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    PageWarper<LotteryCompleteDTO> getCompletePhaseList(LotteryPhaseQueryParam param);

    /**
     * 获取活动详情
     *
     * @param param 查询参数
     * @return 活动详情
     */
    LotteryPhaseDetailDTO getDetail(LotteryPhaseQueryParam param);
}

