package com.bxm.fossicker.activity.lottery.service.impl;

import com.bxm.fossicker.activity.facade.LotteryFacadeService;
import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.activity.lottery.service.LotteryPhaseService;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.vo.PageWarper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryFacadeServiceImpl implements LotteryFacadeService {

    private final LotteryPhaseService lotteryPhaseService;

    @Autowired
    public LotteryFacadeServiceImpl(LotteryPhaseService lotteryPhaseService) {
        this.lotteryPhaseService = lotteryPhaseService;
    }

    @Override
    public LotteryDTO getTopLottery() {
        LotteryQueryParam param = new LotteryQueryParam();
        param.setPageSize(1);

        PageWarper<LotteryDTO> phaseList = lotteryPhaseService.getPhaseList(param);

        if (!CollectionUtils.isEmpty(phaseList.getList())) {
            return phaseList.getList().get(0);
        }

        return null;
    }
}
