package com.bxm.fossicker.activity.lottery.timer;

import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 用户抽奖机会重置后发起推送
 */
@Component
public class DrawChanceResetTimer extends AbstractTaskCallback<Long> {

    private PushFacadeService pushFacadeService;

    @Autowired
    public DrawChanceResetTimer(PushFacadeService pushFacadeService) {
        this.pushFacadeService = pushFacadeService;
    }


    @Override
    protected ReturnT<String> service(Long userId) {
        PushMessage message = PushMessage.build();
        message.setTitle("抽奖机会已到位");
        message.setContent("【0元夺宝】你的5次机会已到位，大奖离你只有一步啦！");
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.getPayloadInfo().setProtocol("qtj://luckyDraw/luckyDrawMainDetail");

        pushFacadeService.push(message);

        return ReturnT.SUCCESS;
    }
}
