package com.bxm.fossicker.activity.service;

import java.math.BigDecimal;

/**
 * 账户金币奖励内部服务调用
 *
 * @author zhaoxin
 **/
public interface AccountIntegrationService {

    /**
     * 签到奖励(活动)
     */
    void rewardSign(Long userId, BigDecimal amount);

    /**
     * 任务领取奖励
     *
     */
    void rewardTask(Long userId, BigDecimal amount, Long taskId);

    /**
     * 完成浏览10s商品(活动)
     */
    void rewardFinishView(Long userId);

    /**
     * 天天领现金奖励(活动)
     */
    void rewardDayGold(Long userId, BigDecimal amount, Long relationId);

    /**
     * 新人红包领取(活动)
     *
     * @param userId 用户id
     */
    void rewardNewUserRedPacket(Long userId);

    /**
     * 分享商品被浏览
     */
    void rewardShareView(Long userId);
}
