package com.bxm.fossicker.activity.service;


import com.bxm.fossicker.activity.model.dto.PhoneStatusDto;
import com.bxm.fossicker.activity.model.param.AddPhoneListParam;

import java.util.List;

/**
 * @ClassName UserAddressListService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/2 17:48
 * @Version 1.0.0
 **/
public interface UserAddressListService {

    /**
     * 上传用户手机号，返回手机号与用户的状态
     * <p>
     * 1.对手机号列表进行去重
     * 2.新增该用户新增的手机号到通讯录中
     * 3.获取该用户的通讯录
     * 4.查询哪些手机号已经开通过账号且不属于该用户，从返回列表中删除
     * 5.查询哪些手机号已经开通过账号且属于该用户，设置已邀请
     *
     * @param addPhoneListParam 用户手机号列表
     * @return 经过筛选的手机号
     */
    List<PhoneStatusDto> uploadPhone(AddPhoneListParam addPhoneListParam);


    Boolean invited(Long userId, String phone);

    Long exists(Long userId, String phone);

    Boolean invited(Long id);

    Boolean add(Long userId, String phone);

}
