package com.bxm.fossicker.activity.service;

import com.bxm.fossicker.activity.facade.WithdrawAddFacadeService;
import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import com.bxm.fossicker.enums.WithdrawTypeEnum;

import java.util.List;

/**
 * 活动提现服务
 *
 * @ClassName WithdrawService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/24 11:23
 * @Version 1.0.0
 **/
public interface WithdrawService extends WithdrawAddFacadeService {

    /**
     * 根据用户id获取未过期可用活动提现
     *
     * @param userId 用户id
     */
    List<ActivityWithdraw> listByUserId(Long userId);

    /**
     * 根据类型获取未提现数据
     *
     * @param userId
     * @return
     */
    List<ActivityWithdraw> listByType(Long userId, Integer type);

    /**
     * 添加活动提现
     *
     * @param userId           用户id
     * @param withdrawTypeEnum 过期时间
     */
    void add(Long userId, WithdrawTypeEnum withdrawTypeEnum);

    /**
     * 使用掉活动提现机会，更新状态
     *
     * @param userId 用户id
     */
    void used(Long userId);

    /**
     * 使用吊活动提现机会  根据类型更新状态  1.4.1
     *
     * @param userId
     * @param id
     * @param type
     */
    void used(Long userId, Long id, Integer type);

}
