package com.bxm.fossicker.activity.service.advert;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.dto.ClassificationDTO;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.activity.model.param.AdvertRelationParam;
import com.bxm.fossicker.base.param.UserIdParam;

import java.util.List;

/**
 * 广告service
 *
 * @author xin.zhao
 **/
public interface AdvertService {

    /**
     * 从缓存中 获取广告位对应的素材信息
     */
    List<AdvertDto> list(AdvertParam param);

    /**
     * 根据单个广告位获取广告详情
     *
     * @param param 广告参数
     * @return 单个广告位中的素材列表
     */
    List<AdvertDto> getRelationDetail(AdvertRelationParam param);

    /**
     * 获得会员中心下，全部分类的广告
     * @param basicParam
     * @return
     */
    List<ClassificationDTO> listVipClassification(UserIdParam basicParam);
}
