package com.bxm.fossicker.activity.service.advert;

import com.alipay.api.domain.Advert;
import com.bxm.fossicker.activity.model.dto.AdvertSceneDTO;
import com.bxm.fossicker.activity.model.dto.AdvertStrategyDTO;
import com.bxm.fossicker.activity.model.param.AdvertSceneParam;
import com.bxm.fossicker.vo.BasicParam;

import java.util.List;

/**
 * 广告策略接口
 *
 * @author liujia
 * @date 2020/01/14 11:14
 */
public interface AdvertStrategyService {
    /**
     * 获取广告播放策略
     *
     * @param basicParam 基础信息
     * @return 广告播放策略
     */
    List<AdvertStrategyDTO> getAdvertStrategy(BasicParam basicParam);

    /**
     * 广告分场景下发
     * @param param 参数
     * @return 广告内容实体
     */
    AdvertSceneDTO getAdvertForScene(AdvertSceneParam param);
}
