package com.bxm.fossicker.activity.service.advert.bo;

import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.vo.BaseParam;
import lombok.*;

/**
 * @authoer Gonzo
 * @date 2019-08-21 09:56
 */
@EqualsAndHashCode(callSuper = true)
@ToString
@Data
@Builder
public class AdvertisementFilterParam extends BaseParam {

    /**
     * 广告位
     *
     * @see AdvertPositionEnum
     */
    private Integer position;

    /**
     * 原始的广告获取请求参数
     */
    AdvertParam advertParam;

    @Setter
    private UserInfoFacadeService userInfoFacadeService;

    /**
     * 请求的用户信息，在获取时加载，防止重复请求
     */
    private UserInfoDto userInfoDto;

    public UserInfoDto getUserInfoDto() {
        if (null == userInfoDto) {
            if (null != userInfoFacadeService && null != advertParam.getUserId()) {
                userInfoDto = userInfoFacadeService.getUserById(advertParam.getUserId());
            }
        }
        return userInfoDto;
    }
}
