package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.base.facade.AppVersionFacadeService;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import org.springframework.beans.BeanUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @authoer Gonzo
 * @date 2019-08-21 10:17
 * <p>
 * 审核提包状态下，过滤掉对应的广告
 */
@AdverFilter
public class AuditFilter extends AbstractAdvertisementFilter {

    @Resource
    private AppVersionFacadeService appVersionFacadeService;


    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam para) {
        // 提审内容控制
        AppVersionParam param = new AppVersionParam();
        BeanUtils.copyProperties(para.getAdvertParam(), param);

        if (appVersionFacadeService.getAuditStatus(param)) {
            //===提包状态===
            //去除非提审状态下的广告
            advertDtos.removeIf(advertDto -> 1 == advertDto.getApprovalFlag());

        } else {
            //===非提包状态===
            //去除提审状态下的广告
            advertDtos.removeIf(advertDto -> 2 == advertDto.getApprovalFlag());

        }

        return true;
    }
}
