package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Objects;

/**
 * 话费跳转拦截
 */
@AdverFilter
public class CostJumpFilter extends AbstractAdvertisementFilter {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;


    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        AdvertParam advertParam = param.getAdvertParam();
        if (Objects.nonNull(advertParam)) {
            // 为了添加弹窗数据
            //获取是否获取过话费列表，如果看过了 不用再弹窗了
            KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
            String isExistSeeCostDate = redisHashMapAdapter.get(key, advertParam.getUserId().toString(), String.class);
            advertDtos.forEach(advertDto -> {
                String title = advertDto.getTitle();
                //banner位置已确定，没法在首页增加类型，只能按照素材来判断
                if (Objects.equals(title, "百元话费")) {
                    advertDto.setUrl(advertDto.getUrl() + "%26qt_detain%3D" + (StringUtils.isNotBlank(isExistSeeCostDate) ? 0 : 1));
                }
            });
        }

        return true;
    }


}
