package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.enums.UserJudgeMarkerEnum;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.tools.BitOperatorUtil;

import java.util.List;

/**
 * 判断用户是否拥有外卖新人首单
 *
 * @author liujia
 * @date 2020/03/23 16:38
 */
@AdverFilter
public class FirstTakeOutOrderFilter extends AbstractAdvertisementFilter {
    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.removeIf(advert -> {
            if (advert.getFirstTakeOutOrderFlag() != null && advert.getFirstTakeOutOrderFlag() != 0) {
                UserInfoDto user = param.getUserInfoDto();

                //条件为首单机会则弹，并且用户有首单记录，则不弹
                if (advert.getFirstTakeOutOrderFlag() == 1
                        &&BitOperatorUtil.getBitAsBoolean(user.getJudgeMarker(), UserJudgeMarkerEnum.TAKE_OUT_ORDERED.getIndex())) {
                    return true;
                }

                //条件为无首单机会则弹，并且用户没有首单记录，则不弹
                return advert.getFirstTakeOutOrderFlag() == 2
                        && !BitOperatorUtil.getBitAsBoolean(user.getJudgeMarker(), UserJudgeMarkerEnum.TAKE_OUT_ORDERED.getIndex());
            }
            return false;
        });
        return true;
    }
}
